/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPrincipalThingsRequestMarshaller
implements Marshaller<Request<ListPrincipalThingsRequest>, ListPrincipalThingsRequest> {
    public Request<ListPrincipalThingsRequest> marshall(ListPrincipalThingsRequest listPrincipalThingsRequest) {
        if (listPrincipalThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPrincipalThingsRequest, "AWSIot");
        String target = "AWSIotService.ListPrincipalThings";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalThingsRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)listPrincipalThingsRequest.getPrincipal()));
        }
        String uriResourcePath = "/principals/things?maxResults={maxResults}&nextToken={nextToken}";
        uriResourcePath = uriResourcePath.replace("{nextToken}", listPrincipalThingsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listPrincipalThingsRequest.getNextToken()));
        uriResourcePath = uriResourcePath.replace("{maxResults}", listPrincipalThingsRequest.getMaxResults() == null ? "" : StringUtils.fromInteger((Integer)listPrincipalThingsRequest.getMaxResults()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

