/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListThingsRequestMarshaller
implements Marshaller<Request<ListThingsRequest>, ListThingsRequest> {
    public Request<ListThingsRequest> marshall(ListThingsRequest listThingsRequest) {
        if (listThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listThingsRequest, "AWSIot");
        String target = "AWSIotService.ListThings";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/things?maxResults={maxResults}&nextToken={nextToken}&attributeName={attributeName}&attributeValue={attributeValue}";
        uriResourcePath = uriResourcePath.replace("{nextToken}", listThingsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listThingsRequest.getNextToken()));
        uriResourcePath = uriResourcePath.replace("{maxResults}", listThingsRequest.getMaxResults() == null ? "" : StringUtils.fromInteger((Integer)listThingsRequest.getMaxResults()));
        uriResourcePath = uriResourcePath.replace("{attributeName}", listThingsRequest.getAttributeName() == null ? "" : StringUtils.fromString((String)listThingsRequest.getAttributeName()));
        uriResourcePath = uriResourcePath.replace("{attributeValue}", listThingsRequest.getAttributeValue() == null ? "" : StringUtils.fromString((String)listThingsRequest.getAttributeValue()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

