/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListTopicRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTopicRulesRequestMarshaller
implements Marshaller<Request<ListTopicRulesRequest>, ListTopicRulesRequest> {
    public Request<ListTopicRulesRequest> marshall(ListTopicRulesRequest listTopicRulesRequest) {
        if (listTopicRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTopicRulesRequest, "AWSIot");
        String target = "AWSIotService.ListTopicRules";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/rules?topic={topic}&maxResults={maxResults}&nextToken={nextToken}&ruleDisabled={ruleDisabled}";
        uriResourcePath = uriResourcePath.replace("{topic}", listTopicRulesRequest.getTopic() == null ? "" : StringUtils.fromString((String)listTopicRulesRequest.getTopic()));
        uriResourcePath = uriResourcePath.replace("{maxResults}", listTopicRulesRequest.getMaxResults() == null ? "" : StringUtils.fromInteger((Integer)listTopicRulesRequest.getMaxResults()));
        uriResourcePath = uriResourcePath.replace("{nextToken}", listTopicRulesRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listTopicRulesRequest.getNextToken()));
        uriResourcePath = uriResourcePath.replace("{ruleDisabled}", listTopicRulesRequest.isRuleDisabled() == null ? "" : StringUtils.fromBoolean((Boolean)listTopicRulesRequest.isRuleDisabled()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

