/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        if (publishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishRequest, "AWSIotData");
        String target = "IotMoonrakerService.Publish";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/topics/{topic}?qos={qos}";
        uriResourcePath = uriResourcePath.replace("{topic}", publishRequest.getTopic() == null ? "" : StringUtils.fromString((String)publishRequest.getTopic()));
        uriResourcePath = uriResourcePath.replace("{qos}", publishRequest.getQos() == null ? "" : StringUtils.fromInteger((Integer)publishRequest.getQos()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.addHeader("Content-Length", Integer.toString(publishRequest.getPayload().remaining()));
        request.setContent(BinaryUtils.toStream((ByteBuffer)publishRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

