/*
 * Copyright 2010-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.iot.model;

import java.io.Serializable;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Lists the Device Defender security profile violations discovered during the
 * given time period. You can use filters to limit the results to those alerts
 * issued for a particular security profile, behavior, or thing (device).
 * </p>
 */
public class ListViolationEventsRequest extends AmazonWebServiceRequest implements Serializable {
    /**
     * <p>
     * The start time for the alerts to be listed.
     * </p>
     */
    private java.util.Date startTime;

    /**
     * <p>
     * The end time for the alerts to be listed.
     * </p>
     */
    private java.util.Date endTime;

    /**
     * <p>
     * A filter to limit results to those alerts caused by the specified thing.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     */
    private String thingName;

    /**
     * <p>
     * A filter to limit results to those alerts generated by the specified
     * security profile.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[a-zA-Z0-9:_-]+<br/>
     */
    private String securityProfileName;

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>STATIC, STATISTICAL, MACHINE_LEARNING
     */
    private String behaviorCriteriaType;

    /**
     * <p>
     * A list of all suppressed alerts.
     * </p>
     */
    private Boolean listSuppressedAlerts;

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 250<br/>
     */
    private Integer maxResults;

    /**
     * <p>
     * The start time for the alerts to be listed.
     * </p>
     *
     * @return <p>
     *         The start time for the alerts to be listed.
     *         </p>
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * <p>
     * The start time for the alerts to be listed.
     * </p>
     *
     * @param startTime <p>
     *            The start time for the alerts to be listed.
     *            </p>
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * <p>
     * The start time for the alerts to be listed.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param startTime <p>
     *            The start time for the alerts to be listed.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withStartTime(java.util.Date startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * <p>
     * The end time for the alerts to be listed.
     * </p>
     *
     * @return <p>
     *         The end time for the alerts to be listed.
     *         </p>
     */
    public java.util.Date getEndTime() {
        return endTime;
    }

    /**
     * <p>
     * The end time for the alerts to be listed.
     * </p>
     *
     * @param endTime <p>
     *            The end time for the alerts to be listed.
     *            </p>
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * <p>
     * The end time for the alerts to be listed.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param endTime <p>
     *            The end time for the alerts to be listed.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withEndTime(java.util.Date endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * <p>
     * A filter to limit results to those alerts caused by the specified thing.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     *
     * @return <p>
     *         A filter to limit results to those alerts caused by the specified
     *         thing.
     *         </p>
     */
    public String getThingName() {
        return thingName;
    }

    /**
     * <p>
     * A filter to limit results to those alerts caused by the specified thing.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     *
     * @param thingName <p>
     *            A filter to limit results to those alerts caused by the
     *            specified thing.
     *            </p>
     */
    public void setThingName(String thingName) {
        this.thingName = thingName;
    }

    /**
     * <p>
     * A filter to limit results to those alerts caused by the specified thing.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     *
     * @param thingName <p>
     *            A filter to limit results to those alerts caused by the
     *            specified thing.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withThingName(String thingName) {
        this.thingName = thingName;
        return this;
    }

    /**
     * <p>
     * A filter to limit results to those alerts generated by the specified
     * security profile.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[a-zA-Z0-9:_-]+<br/>
     *
     * @return <p>
     *         A filter to limit results to those alerts generated by the
     *         specified security profile.
     *         </p>
     */
    public String getSecurityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * A filter to limit results to those alerts generated by the specified
     * security profile.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[a-zA-Z0-9:_-]+<br/>
     *
     * @param securityProfileName <p>
     *            A filter to limit results to those alerts generated by the
     *            specified security profile.
     *            </p>
     */
    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    /**
     * <p>
     * A filter to limit results to those alerts generated by the specified
     * security profile.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[a-zA-Z0-9:_-]+<br/>
     *
     * @param securityProfileName <p>
     *            A filter to limit results to those alerts generated by the
     *            specified security profile.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
        return this;
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>STATIC, STATISTICAL, MACHINE_LEARNING
     *
     * @return <p>
     *         The criteria for a behavior.
     *         </p>
     * @see BehaviorCriteriaType
     */
    public String getBehaviorCriteriaType() {
        return behaviorCriteriaType;
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>STATIC, STATISTICAL, MACHINE_LEARNING
     *
     * @param behaviorCriteriaType <p>
     *            The criteria for a behavior.
     *            </p>
     * @see BehaviorCriteriaType
     */
    public void setBehaviorCriteriaType(String behaviorCriteriaType) {
        this.behaviorCriteriaType = behaviorCriteriaType;
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>STATIC, STATISTICAL, MACHINE_LEARNING
     *
     * @param behaviorCriteriaType <p>
     *            The criteria for a behavior.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     * @see BehaviorCriteriaType
     */
    public ListViolationEventsRequest withBehaviorCriteriaType(String behaviorCriteriaType) {
        this.behaviorCriteriaType = behaviorCriteriaType;
        return this;
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>STATIC, STATISTICAL, MACHINE_LEARNING
     *
     * @param behaviorCriteriaType <p>
     *            The criteria for a behavior.
     *            </p>
     * @see BehaviorCriteriaType
     */
    public void setBehaviorCriteriaType(BehaviorCriteriaType behaviorCriteriaType) {
        this.behaviorCriteriaType = behaviorCriteriaType.toString();
    }

    /**
     * <p>
     * The criteria for a behavior.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Allowed Values: </b>STATIC, STATISTICAL, MACHINE_LEARNING
     *
     * @param behaviorCriteriaType <p>
     *            The criteria for a behavior.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     * @see BehaviorCriteriaType
     */
    public ListViolationEventsRequest withBehaviorCriteriaType(
            BehaviorCriteriaType behaviorCriteriaType) {
        this.behaviorCriteriaType = behaviorCriteriaType.toString();
        return this;
    }

    /**
     * <p>
     * A list of all suppressed alerts.
     * </p>
     *
     * @return <p>
     *         A list of all suppressed alerts.
     *         </p>
     */
    public Boolean isListSuppressedAlerts() {
        return listSuppressedAlerts;
    }

    /**
     * <p>
     * A list of all suppressed alerts.
     * </p>
     *
     * @return <p>
     *         A list of all suppressed alerts.
     *         </p>
     */
    public Boolean getListSuppressedAlerts() {
        return listSuppressedAlerts;
    }

    /**
     * <p>
     * A list of all suppressed alerts.
     * </p>
     *
     * @param listSuppressedAlerts <p>
     *            A list of all suppressed alerts.
     *            </p>
     */
    public void setListSuppressedAlerts(Boolean listSuppressedAlerts) {
        this.listSuppressedAlerts = listSuppressedAlerts;
    }

    /**
     * <p>
     * A list of all suppressed alerts.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param listSuppressedAlerts <p>
     *            A list of all suppressed alerts.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withListSuppressedAlerts(Boolean listSuppressedAlerts) {
        this.listSuppressedAlerts = listSuppressedAlerts;
        return this;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     *
     * @return <p>
     *         The token for the next set of results.
     *         </p>
     */
    public String getNextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     *
     * @param nextToken <p>
     *            The token for the next set of results.
     *            </p>
     */
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param nextToken <p>
     *            The token for the next set of results.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 250<br/>
     *
     * @return <p>
     *         The maximum number of results to return at one time.
     *         </p>
     */
    public Integer getMaxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 250<br/>
     *
     * @param maxResults <p>
     *            The maximum number of results to return at one time.
     *            </p>
     */
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Range: </b>1 - 250<br/>
     *
     * @param maxResults <p>
     *            The maximum number of results to return at one time.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public ListViolationEventsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStartTime() != null)
            sb.append("startTime: " + getStartTime() + ",");
        if (getEndTime() != null)
            sb.append("endTime: " + getEndTime() + ",");
        if (getThingName() != null)
            sb.append("thingName: " + getThingName() + ",");
        if (getSecurityProfileName() != null)
            sb.append("securityProfileName: " + getSecurityProfileName() + ",");
        if (getBehaviorCriteriaType() != null)
            sb.append("behaviorCriteriaType: " + getBehaviorCriteriaType() + ",");
        if (getListSuppressedAlerts() != null)
            sb.append("listSuppressedAlerts: " + getListSuppressedAlerts() + ",");
        if (getNextToken() != null)
            sb.append("nextToken: " + getNextToken() + ",");
        if (getMaxResults() != null)
            sb.append("maxResults: " + getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        hashCode = prime * hashCode + ((getEndTime() == null) ? 0 : getEndTime().hashCode());
        hashCode = prime * hashCode + ((getThingName() == null) ? 0 : getThingName().hashCode());
        hashCode = prime * hashCode
                + ((getSecurityProfileName() == null) ? 0 : getSecurityProfileName().hashCode());
        hashCode = prime * hashCode
                + ((getBehaviorCriteriaType() == null) ? 0 : getBehaviorCriteriaType().hashCode());
        hashCode = prime * hashCode
                + ((getListSuppressedAlerts() == null) ? 0 : getListSuppressedAlerts().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListViolationEventsRequest == false)
            return false;
        ListViolationEventsRequest other = (ListViolationEventsRequest) obj;

        if (other.getStartTime() == null ^ this.getStartTime() == null)
            return false;
        if (other.getStartTime() != null
                && other.getStartTime().equals(this.getStartTime()) == false)
            return false;
        if (other.getEndTime() == null ^ this.getEndTime() == null)
            return false;
        if (other.getEndTime() != null && other.getEndTime().equals(this.getEndTime()) == false)
            return false;
        if (other.getThingName() == null ^ this.getThingName() == null)
            return false;
        if (other.getThingName() != null
                && other.getThingName().equals(this.getThingName()) == false)
            return false;
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null)
            return false;
        if (other.getSecurityProfileName() != null
                && other.getSecurityProfileName().equals(this.getSecurityProfileName()) == false)
            return false;
        if (other.getBehaviorCriteriaType() == null ^ this.getBehaviorCriteriaType() == null)
            return false;
        if (other.getBehaviorCriteriaType() != null
                && other.getBehaviorCriteriaType().equals(this.getBehaviorCriteriaType()) == false)
            return false;
        if (other.getListSuppressedAlerts() == null ^ this.getListSuppressedAlerts() == null)
            return false;
        if (other.getListSuppressedAlerts() != null
                && other.getListSuppressedAlerts().equals(this.getListSuppressedAlerts()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null
                && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null
                && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }
}
