/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.iot;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.iot.AWSIotCertificateException;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttClientStatusCallback;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttLastWillAndTestament;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttMessageDeliveryCallback;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttNewMessageCallback;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttQos;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttQueueMessage;
import com.amazonaws.mobileconnectors.iot.AWSIotMqttTopic;
import com.amazonaws.mobileconnectors.iot.AWSIotSslUtility;
import com.amazonaws.mobileconnectors.iot.AWSIotWebSocketUrlSigner;
import com.amazonaws.mobileconnectors.iot.AwsIotEndpointUtility;
import com.amazonaws.mobileconnectors.iot.MqttManagerConnectionState;
import com.amazonaws.mobileconnectors.iot.PublishMessageUserData;
import com.amazonaws.regions.Region;
import com.amazonaws.util.StringUtils;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class AWSIotMqttManager {
    private static final Integer ANDROID_API_LEVEL_16 = 16;
    private static final Integer MILLIS_IN_ONE_SECOND = 1000;
    private static final Log LOGGER = LogFactory.getLog(AWSIotMqttManager.class);
    private static final int ENDPOINT_SPLIT_SIZE = 5;
    private static final int ENDPOINT_IOT_OFFSET = 1;
    private static final int ENDPOINT_DOMAIN_OFFSET = 3;
    private static final int ENDPOINT_TLD_OFFSET = 4;
    public static final Integer DEFAULT_MIN_RECONNECT_RETRY_TIME_SECONDS = 4;
    public static final Integer DEFAULT_MAX_RECONNECT_RETRY_TIME_SECONDS = 64;
    public static final Boolean DEFAULT_AUTO_RECONNECT_ENABLED = true;
    public static final Integer DEFAULT_AUTO_RECONNECT_ATTEMPTS = 10;
    public static final Integer DEFAULT_KEEP_ALIVE_SECONDS = 10;
    public static final Boolean DEFAULT_OFFLINE_PUBLISH_QUEUE_ENABLED = true;
    public static final Integer DEFAULT_OFFLINE_PUBLISH_QUEUE_BOUND = 100;
    private static final Long DEFAULT_MILLIS_BETWEEN_QUEUE_PUBLISHES = 250L;
    private static final Integer DEFAULT_CONNECTION_STABILITY_TIME_SECONDS = 10;
    private MqttAsyncClient mqttClient;
    private String mqttBrokerURL;
    private AWSIotWebSocketUrlSigner signer;
    private final String accountEndpointPrefix;
    private final String mqttClientId;
    private final Region region;
    private Boolean isWebSocketClient;
    private AWSIotMqttClientStatusCallback userStatusCallback;
    private final Map<String, AWSIotMqttTopic> topicListeners;
    private final List<AWSIotMqttQueueMessage> mqttMessageQueue;
    private int userKeepAlive;
    private AWSIotMqttLastWillAndTestament mqttLWT;
    private boolean autoReconnect;
    private int minReconnectRetryTime;
    private int maxReconnectRetryTime;
    private int currentReconnectRetryTime;
    private int maxAutoReconnectAttempts;
    private int autoReconnectsAttempted;
    private boolean offlinePublishQueueEnabled;
    private Integer offlinePublishQueueBound;
    private boolean fullQueueKeepsOldest;
    private long drainingInterval;
    private boolean userDisconnect;
    private boolean needResubscribe;
    private SocketFactory clientSocketFactory;
    private AWSCredentialsProvider clientCredentialsProvider;
    private Integer connectionStabilityTime;
    private Long lastConnackTime;
    private MqttManagerConnectionState connectionState;
    private Long unitTestMillisOverride;

    public String getAccountEndpointPrefix() {
        return this.accountEndpointPrefix;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean enabled) {
        this.autoReconnect = enabled;
    }

    @Deprecated
    public int getReconnectTimeout() {
        return this.minReconnectRetryTime;
    }

    @Deprecated
    public void setReconnectTimeout(int timeout) {
        this.minReconnectRetryTime = timeout;
    }

    public void setReconnectRetryLimits(int minTimeout, int maxTimeout) {
        if (minTimeout > maxTimeout) {
            throw new IllegalArgumentException("Minimum reconnect time needs to be less than Maximum.");
        }
        this.minReconnectRetryTime = minTimeout;
        this.maxReconnectRetryTime = maxTimeout;
    }

    public int getMinReconnectRetryTime() {
        return this.minReconnectRetryTime;
    }

    public int getMaxReconnectRetryTime() {
        return this.maxReconnectRetryTime;
    }

    public int getMaxAutoReconnectAttempts() {
        return this.maxAutoReconnectAttempts;
    }

    public void setMaxAutoReconnectAttepts(int attempts) {
        if (attempts <= 0 && attempts != -1) {
            throw new IllegalArgumentException("Max reconnection attempts must be postive or -1");
        }
        this.maxAutoReconnectAttempts = attempts;
    }

    public void setConnectionStabilityTime(int time) {
        this.connectionStabilityTime = time;
    }

    public int getConnectionStabilityTime() {
        return this.connectionStabilityTime;
    }

    public boolean isOfflinePublishQueueEnabled() {
        return this.offlinePublishQueueEnabled;
    }

    public void setOfflinePublishQueueEnabled(boolean enabled) {
        this.offlinePublishQueueEnabled = enabled;
    }

    public Integer getOfflinePublishQueueBound() {
        return this.offlinePublishQueueBound;
    }

    public void setOfflinePublishQueueBound(Integer bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("Offline queue bound must be > 0");
        }
        this.offlinePublishQueueBound = bound;
    }

    public Long getDrainingInterval() {
        return this.drainingInterval;
    }

    public void setDrainingInterval(Long interval) {
        this.drainingInterval = interval;
    }

    public boolean fullPublishQueueKeepsOldestMessages() {
        return this.fullQueueKeepsOldest;
    }

    public void setFullQueueToKeepOldestMessages() {
        this.fullQueueKeepsOldest = true;
    }

    public void setFullQueueToKeepNewestMessages() {
        this.fullQueueKeepsOldest = false;
    }

    public int getKeepAlive() {
        return this.userKeepAlive;
    }

    public void setKeepAlive(int keepAlive) {
        if (keepAlive < 0) {
            throw new IllegalArgumentException("Keep alive must be >= 0");
        }
        this.userKeepAlive = keepAlive;
    }

    public AWSIotMqttLastWillAndTestament getMqttLastWillAndTestament() {
        return this.mqttLWT;
    }

    public void setMqttLastWillAndTestament(AWSIotMqttLastWillAndTestament lwt) {
        this.mqttLWT = lwt;
    }

    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.clientCredentialsProvider = credentialsProvider;
    }

    void setMqttClient(MqttAsyncClient client) {
        this.mqttClient = client;
    }

    List<AWSIotMqttQueueMessage> getMqttMessageQueue() {
        return this.mqttMessageQueue;
    }

    MqttManagerConnectionState getConnectionState() {
        return this.connectionState;
    }

    void setUnitTestMillisOverride(Long timeMs) {
        this.unitTestMillisOverride = timeMs;
    }

    Region getRegion() {
        return this.region;
    }

    private Long getSystemTimeMs() {
        if (this.unitTestMillisOverride == null) {
            return System.currentTimeMillis();
        }
        return this.unitTestMillisOverride;
    }

    public void setAutoResubscribe(boolean enabled) {
        this.needResubscribe = enabled;
    }

    public AWSIotMqttManager(String mqttClientId, String endpoint) {
        if (mqttClientId == null || mqttClientId.isEmpty()) {
            throw new IllegalArgumentException("mqttClientId is null or empty");
        }
        this.topicListeners = new HashMap<String, AWSIotMqttTopic>();
        this.mqttMessageQueue = new LinkedList<AWSIotMqttQueueMessage>();
        this.accountEndpointPrefix = AwsIotEndpointUtility.getAccountPrefixFromEndpont(endpoint);
        this.mqttClientId = mqttClientId;
        this.region = AwsIotEndpointUtility.getRegionFromIotEndpoint(endpoint);
        this.initDefaults();
    }

    public AWSIotMqttManager(String mqttClientId, Region region, String accountEndpointPrefix) {
        if (mqttClientId == null || mqttClientId.isEmpty()) {
            throw new IllegalArgumentException("mqttClientId is null or empty");
        }
        if (region == null) {
            throw new IllegalArgumentException("region is null");
        }
        if (accountEndpointPrefix == null) {
            throw new IllegalArgumentException("accountEndpointPrefix is null");
        }
        this.topicListeners = new HashMap<String, AWSIotMqttTopic>();
        this.mqttMessageQueue = new LinkedList<AWSIotMqttQueueMessage>();
        this.accountEndpointPrefix = accountEndpointPrefix;
        this.mqttClientId = mqttClientId;
        this.region = region;
        this.initDefaults();
    }

    private void initDefaults() {
        this.connectionState = MqttManagerConnectionState.Disconnected;
        this.autoReconnect = DEFAULT_AUTO_RECONNECT_ENABLED;
        this.minReconnectRetryTime = DEFAULT_MIN_RECONNECT_RETRY_TIME_SECONDS;
        this.maxReconnectRetryTime = DEFAULT_MAX_RECONNECT_RETRY_TIME_SECONDS;
        this.maxAutoReconnectAttempts = DEFAULT_AUTO_RECONNECT_ATTEMPTS;
        this.userKeepAlive = DEFAULT_KEEP_ALIVE_SECONDS;
        this.mqttLWT = null;
        this.offlinePublishQueueEnabled = DEFAULT_OFFLINE_PUBLISH_QUEUE_ENABLED;
        this.offlinePublishQueueBound = DEFAULT_OFFLINE_PUBLISH_QUEUE_BOUND;
        this.drainingInterval = DEFAULT_MILLIS_BETWEEN_QUEUE_PUBLISHES;
        this.setFullQueueToKeepNewestMessages();
        this.connectionStabilityTime = DEFAULT_CONNECTION_STABILITY_TIME_SECONDS;
        this.unitTestMillisOverride = null;
        this.needResubscribe = true;
    }

    public void connect(KeyStore keyStore, AWSIotMqttClientStatusCallback statusCallback) {
        if (Build.VERSION.SDK_INT < ANDROID_API_LEVEL_16) {
            throw new UnsupportedOperationException("API Level 16+ required for TLS 1.2 Mutual Auth");
        }
        if (keyStore == null) {
            throw new IllegalArgumentException("keyStore is null");
        }
        this.userStatusCallback = statusCallback;
        if (this.connectionState != MqttManagerConnectionState.Disconnected) {
            this.userConnectionCallback();
            return;
        }
        this.mqttBrokerURL = String.format("ssl://%s.iot.%s.%s:8883", this.accountEndpointPrefix, this.region.getName(), this.region.getDomain());
        this.isWebSocketClient = false;
        LOGGER.debug((Object)("MQTT broker: " + this.mqttBrokerURL));
        try {
            if (this.mqttClient == null) {
                this.mqttClient = new MqttAsyncClient(this.mqttBrokerURL, this.mqttClientId, (MqttClientPersistence)new MemoryPersistence());
            }
            SSLSocketFactory socketFactory = AWSIotSslUtility.getSocketFactoryWithKeyStore(keyStore);
            MqttConnectOptions options = new MqttConnectOptions();
            if (this.mqttLWT != null) {
                options.setWill(this.mqttLWT.getTopic(), this.mqttLWT.getMessage().getBytes(), this.mqttLWT.getQos().asInt(), false);
            }
            this.clientSocketFactory = socketFactory;
            options.setSocketFactory(this.clientSocketFactory);
            this.mqttConnect(options, statusCallback);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("A certificate error occurred.", e);
        }
        catch (KeyManagementException e) {
            throw new AWSIotCertificateException("A certificate error occurred.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("A certificate error occurred.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new AWSIotCertificateException("A certificate error occurred.", e);
        }
        catch (MqttException e) {
            throw new AmazonClientException("An error occured in the MQTT client.", (Throwable)e);
        }
    }

    public void connect(AWSCredentialsProvider credentialsProvider, final AWSIotMqttClientStatusCallback statusCallback) {
        this.clientCredentialsProvider = credentialsProvider;
        if (credentialsProvider == null) {
            throw new IllegalArgumentException("credentials provider cannot be null");
        }
        this.userStatusCallback = statusCallback;
        if (this.connectionState != MqttManagerConnectionState.Disconnected) {
            this.userConnectionCallback();
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                AWSIotMqttManager.this.signer = new AWSIotWebSocketUrlSigner("iotdata");
                String endpoint = String.format("%s.iot.%s.%s:443", AWSIotMqttManager.this.accountEndpointPrefix, AWSIotMqttManager.this.region.getName(), AWSIotMqttManager.this.region.getDomain());
                AWSIotMqttManager.this.isWebSocketClient = true;
                LOGGER.debug((Object)("MQTT broker: " + endpoint));
                try {
                    String mqttWebSocketURL = AWSIotMqttManager.this.signer.getSignedUrl(endpoint, AWSIotMqttManager.this.clientCredentialsProvider.getCredentials(), System.currentTimeMillis());
                    MqttConnectOptions options = new MqttConnectOptions();
                    options.setServerURIs(new String[]{mqttWebSocketURL});
                    if (AWSIotMqttManager.this.mqttLWT != null) {
                        options.setWill(AWSIotMqttManager.this.mqttLWT.getTopic(), AWSIotMqttManager.this.mqttLWT.getMessage().getBytes(), AWSIotMqttManager.this.mqttLWT.getQos().asInt(), false);
                    }
                    if (AWSIotMqttManager.this.mqttClient == null) {
                        AWSIotMqttManager.this.mqttClient = new MqttAsyncClient("wss://" + endpoint, AWSIotMqttManager.this.mqttClientId, (MqttClientPersistence)new MemoryPersistence());
                    }
                    AWSIotMqttManager.this.mqttConnect(options, statusCallback);
                }
                catch (MqttException e) {
                    throw new AmazonClientException("An error occurred in the MQTT client.", (Throwable)e);
                }
            }
        }, "Mqtt Connect Thread").start();
    }

    private void mqttConnect(MqttConnectOptions options, AWSIotMqttClientStatusCallback statusCallback) {
        LOGGER.debug((Object)"ready to do mqtt connect");
        options.setCleanSession(true);
        options.setKeepAliveInterval(this.userKeepAlive);
        this.topicListeners.clear();
        this.mqttMessageQueue.clear();
        this.resetReconnect();
        this.userDisconnect = false;
        this.setupCallbackForMqttClient();
        try {
            this.connectionState = MqttManagerConnectionState.Connecting;
            this.userConnectionCallback();
            this.mqttClient.connect(options, null, new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    LOGGER.info((Object)"onSuccess: mqtt connection is successful.");
                    AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Connected;
                    AWSIotMqttManager.this.lastConnackTime = AWSIotMqttManager.this.getSystemTimeMs();
                    if (AWSIotMqttManager.this.mqttMessageQueue.size() > 0) {
                        AWSIotMqttManager.this.publishMessagesFromQueue();
                    }
                    AWSIotMqttManager.this.userConnectionCallback();
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable e) {
                    LOGGER.warn((Object)"onFailure: connection failed.");
                    if (!AWSIotMqttManager.this.userDisconnect && AWSIotMqttManager.this.autoReconnect) {
                        AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Reconnecting;
                        AWSIotMqttManager.this.userConnectionCallback();
                        AWSIotMqttManager.this.scheduleReconnect();
                    } else {
                        AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Disconnected;
                        AWSIotMqttManager.this.userConnectionCallback(e);
                    }
                }
            });
        }
        catch (MqttException e) {
            switch (e.getReasonCode()) {
                case 32100: {
                    this.connectionState = MqttManagerConnectionState.Connected;
                    this.userConnectionCallback();
                    break;
                }
                case 32110: {
                    this.connectionState = MqttManagerConnectionState.Connecting;
                    this.userConnectionCallback();
                    break;
                }
                default: {
                    this.connectionState = MqttManagerConnectionState.Disconnected;
                    this.userConnectionCallback(e);
                }
            }
        }
    }

    public boolean disconnect() {
        this.userDisconnect = true;
        this.reset();
        this.topicListeners.clear();
        this.connectionState = MqttManagerConnectionState.Disconnected;
        this.userConnectionCallback();
        return true;
    }

    void reset() {
        if (null != this.mqttClient && this.mqttClient.isConnected()) {
            try {
                this.mqttClient.disconnect(0L);
            }
            catch (MqttException e) {
                throw new AmazonClientException("Client error when disconnecting.", (Throwable)e);
            }
        }
    }

    void reconnectToSession() {
        if (null != this.mqttClient && this.connectionState != MqttManagerConnectionState.Disconnected) {
            LOGGER.info((Object)"attempting to reconnect to mqtt broker");
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(true);
            options.setKeepAliveInterval(this.userKeepAlive);
            if (this.mqttLWT != null) {
                options.setWill(this.mqttLWT.getTopic(), this.mqttLWT.getMessage().getBytes(), this.mqttLWT.getQos().asInt(), false);
            }
            if (this.isWebSocketClient.booleanValue()) {
                this.signer = new AWSIotWebSocketUrlSigner("iotdata");
                String endpoint = String.format("%s.iot.%s.%s:443", this.accountEndpointPrefix, this.region.getName(), this.region.getDomain());
                try {
                    String mqttWebSocketURL = this.signer.getSignedUrl(endpoint, this.clientCredentialsProvider.getCredentials(), System.currentTimeMillis());
                    LOGGER.debug((Object)("Reconnect to mqtt broker: " + endpoint + " mqttWebSocketURL: " + mqttWebSocketURL));
                    options.setServerURIs(new String[]{mqttWebSocketURL});
                }
                catch (AmazonClientException e) {
                    LOGGER.error((Object)"Failed to get credentials. AmazonClientException: ", (Throwable)e);
                    this.connectionState = this.scheduleReconnect() ? MqttManagerConnectionState.Reconnecting : MqttManagerConnectionState.Disconnected;
                    this.userConnectionCallback();
                }
            } else {
                options.setSocketFactory(this.clientSocketFactory);
            }
            this.setupCallbackForMqttClient();
            try {
                ++this.autoReconnectsAttempted;
                LOGGER.debug((Object)("mqtt reconnecting attempt " + this.autoReconnectsAttempted));
                this.mqttClient.connect(options, null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken asyncActionToken) {
                        LOGGER.info((Object)"Reconnect successful");
                        AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Connected;
                        AWSIotMqttManager.this.lastConnackTime = AWSIotMqttManager.this.getSystemTimeMs();
                        if (AWSIotMqttManager.this.needResubscribe) {
                            AWSIotMqttManager.this.resubscribeToTopics();
                        }
                        if (AWSIotMqttManager.this.mqttMessageQueue.size() > 0) {
                            AWSIotMqttManager.this.publishMessagesFromQueue();
                        }
                        AWSIotMqttManager.this.userConnectionCallback();
                    }

                    public void onFailure(IMqttToken asyncActionToken, Throwable e) {
                        LOGGER.warn((Object)"Reconnect failed ");
                        if (AWSIotMqttManager.this.scheduleReconnect()) {
                            AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Reconnecting;
                            AWSIotMqttManager.this.userConnectionCallback();
                        } else {
                            AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Disconnected;
                            AWSIotMqttManager.this.userConnectionCallback();
                        }
                    }
                });
            }
            catch (MqttException e) {
                LOGGER.error((Object)"Exception during reconnect, exception: ", (Throwable)e);
                if (this.scheduleReconnect()) {
                    this.connectionState = MqttManagerConnectionState.Reconnecting;
                    this.userConnectionCallback();
                }
                this.connectionState = MqttManagerConnectionState.Disconnected;
                this.userConnectionCallback(e);
            }
        }
    }

    private boolean scheduleReconnect() {
        LOGGER.info((Object)("schedule Reconnect attempt " + this.autoReconnectsAttempted + " of " + this.maxAutoReconnectAttempts + " in " + this.currentReconnectRetryTime + " seconds."));
        if (this.maxAutoReconnectAttempts == -1 || this.autoReconnectsAttempted < this.maxAutoReconnectAttempts) {
            final HandlerThread ht = new HandlerThread("Reconnect thread");
            ht.start();
            Looper looper = ht.getLooper();
            Handler handler = new Handler(looper);
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LOGGER.debug((Object)("TID: " + ht.getThreadId() + " trying to reconnect to session"));
                    if (AWSIotMqttManager.this.mqttClient != null && !AWSIotMqttManager.this.mqttClient.isConnected()) {
                        AWSIotMqttManager.this.reconnectToSession();
                    }
                }
            }, (long)(MILLIS_IN_ONE_SECOND * this.currentReconnectRetryTime));
            this.currentReconnectRetryTime = Math.min(this.currentReconnectRetryTime * 2, this.maxReconnectRetryTime);
            return true;
        }
        LOGGER.warn((Object)"schedule reconnect returns false");
        return false;
    }

    public void resetReconnect() {
        LOGGER.info((Object)"resetting reconnect attempt and retry time");
        this.autoReconnectsAttempted = 0;
        this.currentReconnectRetryTime = this.minReconnectRetryTime;
    }

    public void subscribeToTopic(String topic, AWSIotMqttQos qos, AWSIotMqttNewMessageCallback callback) {
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("topic is null or empty");
        }
        if (qos == null) {
            throw new IllegalArgumentException("QoS cannot be null.");
        }
        if (null != this.mqttClient) {
            try {
                this.mqttClient.subscribe(topic, qos.asInt());
            }
            catch (MqttException e) {
                throw new AmazonClientException("Client error when subscribing.", (Throwable)e);
            }
            AWSIotMqttTopic topicModel = new AWSIotMqttTopic(topic, qos, callback);
            this.topicListeners.put(topic, topicModel);
        }
    }

    public void unsubscribeTopic(String topic) {
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("topic is null or empty");
        }
        if (this.mqttClient != null) {
            try {
                this.mqttClient.unsubscribe(topic);
            }
            catch (MqttException e) {
                throw new AmazonClientException("Client error while unsubscribing.", (Throwable)e);
            }
            this.topicListeners.remove(topic);
        }
    }

    void resubscribeToTopics() {
        LOGGER.info((Object)"Auto-resubscribe is enabled. Resubscribing to previous topics.");
        for (AWSIotMqttTopic topic : this.topicListeners.values()) {
            if (this.mqttClient == null) continue;
            try {
                this.mqttClient.subscribe(topic.getTopic(), topic.getQos().asInt());
            }
            catch (MqttException e) {
                LOGGER.error((Object)"Error while resubscribing to previously subscribed toipcs.", (Throwable)e);
            }
        }
    }

    public void publishString(String str, String topic, AWSIotMqttQos qos) {
        if (str == null) {
            throw new IllegalArgumentException("publish string is null");
        }
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("topic is null or empty");
        }
        if (qos == null) {
            throw new IllegalArgumentException("QoS cannot be null");
        }
        this.publishData(str.getBytes(StringUtils.UTF8), topic, qos);
    }

    public void publishString(String str, String topic, AWSIotMqttQos qos, AWSIotMqttMessageDeliveryCallback cb, Object userData) {
        if (str == null) {
            throw new IllegalArgumentException("publish string is null");
        }
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("topic is null or empty");
        }
        if (qos == null) {
            throw new IllegalArgumentException("QoS cannot be null");
        }
        this.publishData(str.getBytes(StringUtils.UTF8), topic, qos, cb, userData);
    }

    public void publishData(byte[] data, String topic, AWSIotMqttQos qos) {
        this.publishData(data, topic, qos, null, null);
    }

    public void publishData(byte[] data, String topic, AWSIotMqttQos qos, AWSIotMqttMessageDeliveryCallback callback, Object userData) {
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("topic is null or empty");
        }
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (qos == null) {
            throw new IllegalArgumentException("QoS cannot be null");
        }
        PublishMessageUserData publishMessageUserData = new PublishMessageUserData(callback, userData);
        if (this.connectionState == MqttManagerConnectionState.Connected) {
            if (this.mqttMessageQueue.isEmpty()) {
                try {
                    this.mqttClient.publish(topic, data, qos.asInt(), false, (Object)publishMessageUserData, null);
                }
                catch (MqttException e) {
                    if (callback != null) {
                        this.userPublishCallback(callback, AWSIotMqttMessageDeliveryCallback.MessageDeliveryStatus.Fail, userData);
                    }
                    throw new AmazonClientException("Client error while publishing.", (Throwable)e);
                }
            } else if (!this.putMessageInQueue(data, topic, qos, publishMessageUserData)) {
                this.userPublishCallback(callback, AWSIotMqttMessageDeliveryCallback.MessageDeliveryStatus.Fail, userData);
            }
        } else if (this.connectionState == MqttManagerConnectionState.Reconnecting) {
            if (this.offlinePublishQueueEnabled && !this.putMessageInQueue(data, topic, qos, publishMessageUserData)) {
                this.userPublishCallback(callback, AWSIotMqttMessageDeliveryCallback.MessageDeliveryStatus.Fail, userData);
            }
        } else {
            throw new AmazonClientException("Client is disconnected or not yet connected.");
        }
    }

    boolean putMessageInQueue(byte[] data, String topic, AWSIotMqttQos qos, PublishMessageUserData publishMessageUserData) {
        AWSIotMqttQueueMessage message = new AWSIotMqttQueueMessage(topic, data, qos, publishMessageUserData);
        if (this.mqttMessageQueue.size() >= this.offlinePublishQueueBound) {
            if (this.fullQueueKeepsOldest) {
                return false;
            }
            this.mqttMessageQueue.remove(0);
        }
        this.mqttMessageQueue.add(message);
        return true;
    }

    void publishMessagesFromQueue() {
        if (this.connectionState == MqttManagerConnectionState.Connected && this.mqttMessageQueue != null && !this.mqttMessageQueue.isEmpty()) {
            AWSIotMqttQueueMessage message = this.mqttMessageQueue.remove(0);
            if (message != null) {
                try {
                    if (message.getUserData() != null && message.getUserData().getUserCallback() != null) {
                        this.mqttClient.publish(message.getTopic(), message.getMessage(), message.getQos().asInt(), false, (Object)message.getUserData(), null);
                    } else {
                        this.mqttClient.publish(message.getTopic(), message.getMessage(), message.getQos().asInt(), false);
                    }
                }
                catch (MqttException e) {
                    this.userPublishCallback(message.getUserData().getUserCallback(), AWSIotMqttMessageDeliveryCallback.MessageDeliveryStatus.Fail, message.getUserData().getUserData());
                }
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!AWSIotMqttManager.this.mqttMessageQueue.isEmpty() && AWSIotMqttManager.this.connectionState == MqttManagerConnectionState.Connected) {
                        AWSIotMqttManager.this.publishMessagesFromQueue();
                    }
                }
            }, this.drainingInterval);
        }
    }

    void setupCallbackForMqttClient() {
        LOGGER.debug((Object)"Setting up Callback for MqttClient");
        this.mqttClient.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                LOGGER.warn((Object)"connection is Lost");
                if (!AWSIotMqttManager.this.userDisconnect && AWSIotMqttManager.this.autoReconnect) {
                    AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Reconnecting;
                    AWSIotMqttManager.this.userConnectionCallback();
                    if (AWSIotMqttManager.this.lastConnackTime + (long)(AWSIotMqttManager.this.connectionStabilityTime * MILLIS_IN_ONE_SECOND) < AWSIotMqttManager.this.getSystemTimeMs()) {
                        AWSIotMqttManager.this.resetReconnect();
                    }
                    AWSIotMqttManager.this.scheduleReconnect();
                } else {
                    AWSIotMqttManager.this.connectionState = MqttManagerConnectionState.Disconnected;
                    AWSIotMqttManager.this.userConnectionCallback(cause);
                }
            }

            public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
                LOGGER.info((Object)("message arrived on topic: " + topic));
                byte[] data = mqttMessage.getPayload();
                for (String topicKey : AWSIotMqttManager.this.topicListeners.keySet()) {
                    AWSIotMqttTopic topicModel;
                    if (!AWSIotMqttManager.isTopicMatch(topicKey, topic) || (topicModel = (AWSIotMqttTopic)AWSIotMqttManager.this.topicListeners.get(topicKey)) == null || topicModel.getCallback() == null) continue;
                    topicModel.getCallback().onMessageArrived(topic, data);
                }
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                Object o;
                LOGGER.info((Object)"delivery is complete");
                if (token != null && (o = token.getUserContext()) instanceof PublishMessageUserData) {
                    PublishMessageUserData pmud = (PublishMessageUserData)o;
                    AWSIotMqttManager.this.userPublishCallback(pmud.getUserCallback(), AWSIotMqttMessageDeliveryCallback.MessageDeliveryStatus.Success, pmud.getUserData());
                }
            }
        });
    }

    boolean isReadyToPublish() {
        return this.mqttClient != null && this.mqttClient.isConnected();
    }

    void userConnectionCallback() {
        this.userConnectionCallback(null);
    }

    void userConnectionCallback(Throwable t) {
        if (this.userStatusCallback != null) {
            switch (this.connectionState) {
                case Connected: {
                    this.userStatusCallback.onStatusChanged(AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.Connected, t);
                    break;
                }
                case Connecting: {
                    this.userStatusCallback.onStatusChanged(AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.Connecting, t);
                    break;
                }
                case Reconnecting: {
                    this.userStatusCallback.onStatusChanged(AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.Reconnecting, t);
                    break;
                }
                case Disconnected: {
                    this.userStatusCallback.onStatusChanged(AWSIotMqttClientStatusCallback.AWSIotMqttClientStatus.ConnectionLost, t);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown connection state.");
                }
            }
        }
    }

    void userPublishCallback(AWSIotMqttMessageDeliveryCallback cb, AWSIotMqttMessageDeliveryCallback.MessageDeliveryStatus status, Object userData) {
        if (cb != null) {
            cb.statusChanged(status, userData);
        }
    }

    static boolean isTopicMatch(String topicFilter, String topic) {
        String[] topicTokens;
        String[] topicFilterTokens = topicFilter.split("/");
        if (topicFilterTokens.length > (topicTokens = topic.split("/")).length) {
            return false;
        }
        for (int i = 0; i < topicFilterTokens.length; ++i) {
            String topicFilterToken = topicFilterTokens[i];
            String topicToken = topicTokens[i];
            if ("#".equals(topicFilterToken)) {
                return true;
            }
            if ("+".equals(topicFilterToken) || topicFilterToken.equals(topicToken)) continue;
            return false;
        }
        return topicFilterTokens.length == topicTokens.length;
    }
}

