/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.iot;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.mobileconnectors.iot.AwsIotEndpointUtility;
import com.amazonaws.regions.Region;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class AWSIotWebSocketUrlSigner {
    private static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String KEY_PREFIX = "AWS4";
    private static final String TERMINATOR = "aws4_request";
    private static final String DATE_PATTERN = "yyyyMMdd";
    private static final String TIME_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final String METHOD = "GET";
    private static final String CANONICAL_URI = "/mqtt";
    private String signerServiceName;
    private Date overriddenDate = null;

    public AWSIotWebSocketUrlSigner(String serviceName) {
        this.signerServiceName = serviceName;
    }

    public String getSignedUrl(String endpoint, AWSCredentials awsCredentials, long currentTimeInMillis) {
        if (awsCredentials instanceof AnonymousAWSCredentials) {
            throw new IllegalArgumentException("Credentials cannot be Anonymous");
        }
        Region signerRegion = AwsIotEndpointUtility.getRegionFromIotEndpoint(endpoint);
        String signerRegionName = signerRegion.getName();
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(awsCredentials);
        String amzDate = this.getAmzDate(currentTimeInMillis);
        String dateStamp = this.getDateStamp(currentTimeInMillis);
        String credentialScope = dateStamp + "/" + signerRegionName + "/" + this.signerServiceName + "/aws4_request";
        StringBuilder canonicalQueryStringBuilder = new StringBuilder();
        canonicalQueryStringBuilder.append("X-Amz-Algorithm=").append(ALGORITHM);
        canonicalQueryStringBuilder.append("&X-Amz-Credential=");
        try {
            canonicalQueryStringBuilder.append(URLEncoder.encode(sanitizedCredentials.getAWSAccessKeyId() + "/" + credentialScope, StringUtils.UTF8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Error encoding URL when building WebSocket URL", (Throwable)e);
        }
        canonicalQueryStringBuilder.append("&X-Amz-Date=").append(amzDate);
        canonicalQueryStringBuilder.append("&X-Amz-SignedHeaders=host");
        String canonicalHeaders = "host:" + endpoint + "\n";
        String payloadHash = BinaryUtils.toHex((byte[])this.hash(""));
        String canonicalRequest = "GET\n/mqtt\n" + canonicalQueryStringBuilder.toString() + "\n" + canonicalHeaders + "\nhost\n" + payloadHash;
        String stringToSign = "AWS4-HMAC-SHA256\n" + amzDate + "\n" + credentialScope + "\n" + BinaryUtils.toHex((byte[])this.hash(canonicalRequest));
        byte[] signingKey = this.getSigningKey(dateStamp, signerRegionName, this.signerServiceName, sanitizedCredentials);
        byte[] signatureBytes = this.sign(stringToSign.getBytes(), signingKey, SigningAlgorithm.HmacSHA256);
        String signature = BinaryUtils.toHex((byte[])signatureBytes);
        canonicalQueryStringBuilder.append("&X-Amz-Signature=");
        canonicalQueryStringBuilder.append(signature);
        String requestUrl = "wss://" + endpoint + CANONICAL_URI + "?" + canonicalQueryStringBuilder.toString();
        if (awsCredentials instanceof AWSSessionCredentials) {
            String sessionToken = null;
            try {
                sessionToken = URLEncoder.encode(((AWSSessionCredentials)awsCredentials).getSessionToken(), StringUtils.UTF8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new AmazonClientException("Error encoding URL when appending session token to URL", (Throwable)e);
            }
            requestUrl = requestUrl + "&X-Amz-Security-Token=" + sessionToken;
        }
        return requestUrl;
    }

    private byte[] getSigningKey(String dateStamp, String regionName, String serviceName, AWSCredentials credentials) {
        byte[] signingSecret = (KEY_PREFIX + credentials.getAWSSecretKey()).getBytes();
        byte[] signingDate = this.sign(dateStamp, signingSecret, SigningAlgorithm.HmacSHA256);
        byte[] signingRegion = this.sign(regionName, signingDate, SigningAlgorithm.HmacSHA256);
        byte[] signingService = this.sign(serviceName, signingRegion, SigningAlgorithm.HmacSHA256);
        return this.sign(TERMINATOR, signingService, SigningAlgorithm.HmacSHA256);
    }

    private String getAmzDate(long dateMilli) {
        return DateUtils.format((String)TIME_PATTERN, (Date)new Date(dateMilli));
    }

    private String getDateStamp(long dateMilli) {
        return DateUtils.format((String)DATE_PATTERN, (Date)new Date(dateMilli));
    }

    AWSCredentials sanitizeCredentials(AWSCredentials credentials) {
        String accessKeyId = null;
        String secretKey = null;
        String token = null;
        accessKeyId = credentials.getAWSAccessKeyId();
        secretKey = credentials.getAWSSecretKey();
        if (credentials instanceof AWSSessionCredentials) {
            token = ((AWSSessionCredentials)credentials).getSessionToken();
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (accessKeyId != null) {
            accessKeyId = accessKeyId.trim();
        }
        if (token != null) {
            token = token.trim();
        }
        if (credentials instanceof AWSSessionCredentials) {
            return new BasicSessionCredentials(accessKeyId, secretKey, token);
        }
        return new BasicAWSCredentials(accessKeyId, secretKey);
    }

    byte[] hash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StringUtils.UTF8));
            return md.digest();
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) {
        try {
            byte[] data = stringData.getBytes(StringUtils.UTF8);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }
}

