/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import java.util.HashMap;
import java.util.Map;

public enum CannedAccessControlList {
    Private("private"),
    PublicRead("public-read"),
    PublicReadWrite("public-read-write"),
    AwsExecRead("aws-exec-read"),
    AuthenticatedRead("authenticated-read"),
    BucketOwnerRead("bucket-owner-read"),
    BucketOwnerFullControl("bucket-owner-full-control"),
    LogDeliveryWrite("log-delivery-write");

    private String value;
    private static final Map<String, CannedAccessControlList> enumMap;

    private CannedAccessControlList(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static CannedAccessControlList fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        if (enumMap.containsKey(value)) {
            return enumMap.get(value);
        }
        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }

    static {
        enumMap = new HashMap<String, CannedAccessControlList>();
        enumMap.put("private", Private);
        enumMap.put("public-read", PublicRead);
        enumMap.put("public-read-write", PublicReadWrite);
        enumMap.put("aws-exec-read", AwsExecRead);
        enumMap.put("authenticated-read", AuthenticatedRead);
        enumMap.put("bucket-owner-read", BucketOwnerRead);
        enumMap.put("bucket-owner-full-control", BucketOwnerFullControl);
        enumMap.put("log-delivery-write", LogDeliveryWrite);
    }
}

