/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.CloudwatchAlarmAction;
import com.amazonaws.services.iot.model.CloudwatchMetricAction;
import com.amazonaws.services.iot.model.DynamoDBAction;
import com.amazonaws.services.iot.model.DynamoDBv2Action;
import com.amazonaws.services.iot.model.ElasticsearchAction;
import com.amazonaws.services.iot.model.FirehoseAction;
import com.amazonaws.services.iot.model.KinesisAction;
import com.amazonaws.services.iot.model.LambdaAction;
import com.amazonaws.services.iot.model.RepublishAction;
import com.amazonaws.services.iot.model.S3Action;
import com.amazonaws.services.iot.model.SnsAction;
import com.amazonaws.services.iot.model.SqsAction;
import com.amazonaws.services.iot.model.transform.CloudwatchAlarmActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.CloudwatchMetricActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.DynamoDBActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.DynamoDBv2ActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.ElasticsearchActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.FirehoseActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.KinesisActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.LambdaActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.RepublishActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.S3ActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.SnsActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.SqsActionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class ActionJsonMarshaller {
    private static ActionJsonMarshaller instance;

    ActionJsonMarshaller() {
    }

    public void marshall(Action action, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (action.getDynamoDB() != null) {
            DynamoDBAction dynamoDB = action.getDynamoDB();
            jsonWriter.name("dynamoDB");
            DynamoDBActionJsonMarshaller.getInstance().marshall(dynamoDB, jsonWriter);
        }
        if (action.getDynamoDBv2() != null) {
            DynamoDBv2Action dynamoDBv2 = action.getDynamoDBv2();
            jsonWriter.name("dynamoDBv2");
            DynamoDBv2ActionJsonMarshaller.getInstance().marshall(dynamoDBv2, jsonWriter);
        }
        if (action.getLambda() != null) {
            LambdaAction lambda = action.getLambda();
            jsonWriter.name("lambda");
            LambdaActionJsonMarshaller.getInstance().marshall(lambda, jsonWriter);
        }
        if (action.getSns() != null) {
            SnsAction sns = action.getSns();
            jsonWriter.name("sns");
            SnsActionJsonMarshaller.getInstance().marshall(sns, jsonWriter);
        }
        if (action.getSqs() != null) {
            SqsAction sqs = action.getSqs();
            jsonWriter.name("sqs");
            SqsActionJsonMarshaller.getInstance().marshall(sqs, jsonWriter);
        }
        if (action.getKinesis() != null) {
            KinesisAction kinesis = action.getKinesis();
            jsonWriter.name("kinesis");
            KinesisActionJsonMarshaller.getInstance().marshall(kinesis, jsonWriter);
        }
        if (action.getRepublish() != null) {
            RepublishAction republish = action.getRepublish();
            jsonWriter.name("republish");
            RepublishActionJsonMarshaller.getInstance().marshall(republish, jsonWriter);
        }
        if (action.getS3() != null) {
            S3Action s3 = action.getS3();
            jsonWriter.name("s3");
            S3ActionJsonMarshaller.getInstance().marshall(s3, jsonWriter);
        }
        if (action.getFirehose() != null) {
            FirehoseAction firehose = action.getFirehose();
            jsonWriter.name("firehose");
            FirehoseActionJsonMarshaller.getInstance().marshall(firehose, jsonWriter);
        }
        if (action.getCloudwatchMetric() != null) {
            CloudwatchMetricAction cloudwatchMetric = action.getCloudwatchMetric();
            jsonWriter.name("cloudwatchMetric");
            CloudwatchMetricActionJsonMarshaller.getInstance().marshall(cloudwatchMetric, jsonWriter);
        }
        if (action.getCloudwatchAlarm() != null) {
            CloudwatchAlarmAction cloudwatchAlarm = action.getCloudwatchAlarm();
            jsonWriter.name("cloudwatchAlarm");
            CloudwatchAlarmActionJsonMarshaller.getInstance().marshall(cloudwatchAlarm, jsonWriter);
        }
        if (action.getElasticsearch() != null) {
            ElasticsearchAction elasticsearch = action.getElasticsearch();
            jsonWriter.name("elasticsearch");
            ElasticsearchActionJsonMarshaller.getInstance().marshall(elasticsearch, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static ActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionJsonMarshaller();
        }
        return instance;
    }
}

