/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.AttachThingPrincipalRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AttachThingPrincipalRequestMarshaller
implements Marshaller<Request<AttachThingPrincipalRequest>, AttachThingPrincipalRequest> {
    public Request<AttachThingPrincipalRequest> marshall(AttachThingPrincipalRequest attachThingPrincipalRequest) {
        if (attachThingPrincipalRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AttachThingPrincipalRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachThingPrincipalRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PUT);
        if (attachThingPrincipalRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)attachThingPrincipalRequest.getPrincipal()));
        }
        String uriResourcePath = "/things/{thingName}/principals";
        uriResourcePath = uriResourcePath.replace("{thingName}", attachThingPrincipalRequest.getThingName() == null ? "" : StringUtils.fromString((String)attachThingPrincipalRequest.getThingName()));
        request.setResourcePath(uriResourcePath);
        request.addHeader("Content-Length", "0");
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

