/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.CloudwatchAlarmAction;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class CloudwatchAlarmActionJsonUnmarshaller
implements Unmarshaller<CloudwatchAlarmAction, JsonUnmarshallerContext> {
    private static CloudwatchAlarmActionJsonUnmarshaller instance;

    CloudwatchAlarmActionJsonUnmarshaller() {
    }

    public CloudwatchAlarmAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        CloudwatchAlarmAction cloudwatchAlarmAction = new CloudwatchAlarmAction();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("roleArn")) {
                cloudwatchAlarmAction.setRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("alarmName")) {
                cloudwatchAlarmAction.setAlarmName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("stateReason")) {
                cloudwatchAlarmAction.setStateReason(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("stateValue")) {
                cloudwatchAlarmAction.setStateValue(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return cloudwatchAlarmAction;
    }

    public static CloudwatchAlarmActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CloudwatchAlarmActionJsonUnmarshaller();
        }
        return instance;
    }
}

