/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.CreatePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreatePolicyRequestMarshaller
implements Marshaller<Request<CreatePolicyRequest>, CreatePolicyRequest> {
    public Request<CreatePolicyRequest> marshall(CreatePolicyRequest createPolicyRequest) {
        if (createPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreatePolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPolicyRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/policies/{policyName}";
        uriResourcePath = uriResourcePath.replace("{policyName}", createPolicyRequest.getPolicyName() == null ? "" : StringUtils.fromString((String)createPolicyRequest.getPolicyName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createPolicyRequest.getPolicyDocument() != null) {
                String policyDocument = createPolicyRequest.getPolicyDocument();
                jsonWriter.name("policyDocument");
                jsonWriter.value(policyDocument);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

