/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.AttributePayload;
import com.amazonaws.services.iot.model.CreateThingRequest;
import com.amazonaws.services.iot.model.transform.AttributePayloadJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateThingRequestMarshaller
implements Marshaller<Request<CreateThingRequest>, CreateThingRequest> {
    public Request<CreateThingRequest> marshall(CreateThingRequest createThingRequest) {
        if (createThingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateThingRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = uriResourcePath.replace("{thingName}", createThingRequest.getThingName() == null ? "" : StringUtils.fromString((String)createThingRequest.getThingName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createThingRequest.getThingTypeName() != null) {
                String thingTypeName = createThingRequest.getThingTypeName();
                jsonWriter.name("thingTypeName");
                jsonWriter.value(thingTypeName);
            }
            if (createThingRequest.getAttributePayload() != null) {
                AttributePayload attributePayload = createThingRequest.getAttributePayload();
                jsonWriter.name("attributePayload");
                AttributePayloadJsonMarshaller.getInstance().marshall(attributePayload, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

