/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DeletePolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeletePolicyVersionRequestMarshaller
implements Marshaller<Request<DeletePolicyVersionRequest>, DeletePolicyVersionRequest> {
    public Request<DeletePolicyVersionRequest> marshall(DeletePolicyVersionRequest deletePolicyVersionRequest) {
        if (deletePolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeletePolicyVersionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deletePolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = uriResourcePath.replace("{policyName}", deletePolicyVersionRequest.getPolicyName() == null ? "" : StringUtils.fromString((String)deletePolicyVersionRequest.getPolicyName()));
        uriResourcePath = uriResourcePath.replace("{policyVersionId}", deletePolicyVersionRequest.getPolicyVersionId() == null ? "" : StringUtils.fromString((String)deletePolicyVersionRequest.getPolicyVersionId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

