/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DeleteThingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteThingRequestMarshaller
implements Marshaller<Request<DeleteThingRequest>, DeleteThingRequest> {
    public Request<DeleteThingRequest> marshall(DeleteThingRequest deleteThingRequest) {
        if (deleteThingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteThingRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = uriResourcePath.replace("{thingName}", deleteThingRequest.getThingName() == null ? "" : StringUtils.fromString((String)deleteThingRequest.getThingName()));
        if (deleteThingRequest.getExpectedVersion() != null) {
            request.addParameter("expectedVersion", StringUtils.fromLong((Long)deleteThingRequest.getExpectedVersion()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

