/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DetachPrincipalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachPrincipalPolicyRequestMarshaller
implements Marshaller<Request<DetachPrincipalPolicyRequest>, DetachPrincipalPolicyRequest> {
    public Request<DetachPrincipalPolicyRequest> marshall(DetachPrincipalPolicyRequest detachPrincipalPolicyRequest) {
        if (detachPrincipalPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DetachPrincipalPolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachPrincipalPolicyRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (detachPrincipalPolicyRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-iot-principal", StringUtils.fromString((String)detachPrincipalPolicyRequest.getPrincipal()));
        }
        String uriResourcePath = "/principal-policies/{policyName}";
        uriResourcePath = uriResourcePath.replace("{policyName}", detachPrincipalPolicyRequest.getPolicyName() == null ? "" : StringUtils.fromString((String)detachPrincipalPolicyRequest.getPolicyName()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

