/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DetachThingPrincipalRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachThingPrincipalRequestMarshaller
implements Marshaller<Request<DetachThingPrincipalRequest>, DetachThingPrincipalRequest> {
    public Request<DetachThingPrincipalRequest> marshall(DetachThingPrincipalRequest detachThingPrincipalRequest) {
        if (detachThingPrincipalRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DetachThingPrincipalRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachThingPrincipalRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (detachThingPrincipalRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)detachThingPrincipalRequest.getPrincipal()));
        }
        String uriResourcePath = "/things/{thingName}/principals";
        uriResourcePath = uriResourcePath.replace("{thingName}", detachThingPrincipalRequest.getThingName() == null ? "" : StringUtils.fromString((String)detachThingPrincipalRequest.getThingName()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

