/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.DynamoDBAction;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class DynamoDBActionJsonUnmarshaller
implements Unmarshaller<DynamoDBAction, JsonUnmarshallerContext> {
    private static DynamoDBActionJsonUnmarshaller instance;

    DynamoDBActionJsonUnmarshaller() {
    }

    public DynamoDBAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        DynamoDBAction dynamoDBAction = new DynamoDBAction();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("tableName")) {
                dynamoDBAction.setTableName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("roleArn")) {
                dynamoDBAction.setRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("operation")) {
                dynamoDBAction.setOperation(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("hashKeyField")) {
                dynamoDBAction.setHashKeyField(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("hashKeyValue")) {
                dynamoDBAction.setHashKeyValue(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("hashKeyType")) {
                dynamoDBAction.setHashKeyType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("rangeKeyField")) {
                dynamoDBAction.setRangeKeyField(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("rangeKeyValue")) {
                dynamoDBAction.setRangeKeyValue(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("rangeKeyType")) {
                dynamoDBAction.setRangeKeyType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("payloadField")) {
                dynamoDBAction.setPayloadField(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return dynamoDBAction;
    }

    public static DynamoDBActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DynamoDBActionJsonUnmarshaller();
        }
        return instance;
    }
}

