/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.FirehoseAction;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class FirehoseActionJsonUnmarshaller
implements Unmarshaller<FirehoseAction, JsonUnmarshallerContext> {
    private static FirehoseActionJsonUnmarshaller instance;

    FirehoseActionJsonUnmarshaller() {
    }

    public FirehoseAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        FirehoseAction firehoseAction = new FirehoseAction();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("roleArn")) {
                firehoseAction.setRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("deliveryStreamName")) {
                firehoseAction.setDeliveryStreamName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("separator")) {
                firehoseAction.setSeparator(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return firehoseAction;
    }

    public static FirehoseActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FirehoseActionJsonUnmarshaller();
        }
        return instance;
    }
}

