/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.GetPolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetPolicyVersionRequestMarshaller
implements Marshaller<Request<GetPolicyVersionRequest>, GetPolicyVersionRequest> {
    public Request<GetPolicyVersionRequest> marshall(GetPolicyVersionRequest getPolicyVersionRequest) {
        if (getPolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetPolicyVersionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = uriResourcePath.replace("{policyName}", getPolicyVersionRequest.getPolicyName() == null ? "" : StringUtils.fromString((String)getPolicyVersionRequest.getPolicyName()));
        uriResourcePath = uriResourcePath.replace("{policyVersionId}", getPolicyVersionRequest.getPolicyVersionId() == null ? "" : StringUtils.fromString((String)getPolicyVersionRequest.getPolicyVersionId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

