/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.GetTopicRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetTopicRuleRequestMarshaller
implements Marshaller<Request<GetTopicRuleRequest>, GetTopicRuleRequest> {
    public Request<GetTopicRuleRequest> marshall(GetTopicRuleRequest getTopicRuleRequest) {
        if (getTopicRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetTopicRuleRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/rules/{ruleName}";
        uriResourcePath = uriResourcePath.replace("{ruleName}", getTopicRuleRequest.getRuleName() == null ? "" : StringUtils.fromString((String)getTopicRuleRequest.getRuleName()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

