/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.KinesisAction;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class KinesisActionJsonUnmarshaller
implements Unmarshaller<KinesisAction, JsonUnmarshallerContext> {
    private static KinesisActionJsonUnmarshaller instance;

    KinesisActionJsonUnmarshaller() {
    }

    public KinesisAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        KinesisAction kinesisAction = new KinesisAction();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("roleArn")) {
                kinesisAction.setRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("streamName")) {
                kinesisAction.setStreamName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("partitionKey")) {
                kinesisAction.setPartitionKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return kinesisAction;
    }

    public static KinesisActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KinesisActionJsonUnmarshaller();
        }
        return instance;
    }
}

