/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListCACertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListCACertificatesRequestMarshaller
implements Marshaller<Request<ListCACertificatesRequest>, ListCACertificatesRequest> {
    public Request<ListCACertificatesRequest> marshall(ListCACertificatesRequest listCACertificatesRequest) {
        if (listCACertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListCACertificatesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCACertificatesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/cacertificates";
        if (listCACertificatesRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listCACertificatesRequest.getPageSize()));
        }
        if (listCACertificatesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listCACertificatesRequest.getMarker()));
        }
        if (listCACertificatesRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listCACertificatesRequest.getAscendingOrder()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

