/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListCertificatesRequestMarshaller
implements Marshaller<Request<ListCertificatesRequest>, ListCertificatesRequest> {
    public Request<ListCertificatesRequest> marshall(ListCertificatesRequest listCertificatesRequest) {
        if (listCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListCertificatesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCertificatesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/certificates";
        if (listCertificatesRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listCertificatesRequest.getPageSize()));
        }
        if (listCertificatesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listCertificatesRequest.getMarker()));
        }
        if (listCertificatesRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listCertificatesRequest.getAscendingOrder()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

