/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListOutgoingCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListOutgoingCertificatesRequestMarshaller
implements Marshaller<Request<ListOutgoingCertificatesRequest>, ListOutgoingCertificatesRequest> {
    public Request<ListOutgoingCertificatesRequest> marshall(ListOutgoingCertificatesRequest listOutgoingCertificatesRequest) {
        if (listOutgoingCertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListOutgoingCertificatesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listOutgoingCertificatesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/certificates-out-going";
        if (listOutgoingCertificatesRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listOutgoingCertificatesRequest.getPageSize()));
        }
        if (listOutgoingCertificatesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listOutgoingCertificatesRequest.getMarker()));
        }
        if (listOutgoingCertificatesRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listOutgoingCertificatesRequest.getAscendingOrder()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

