/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        if (listPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListPoliciesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPoliciesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies";
        if (listPoliciesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listPoliciesRequest.getMarker()));
        }
        if (listPoliciesRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger((Integer)listPoliciesRequest.getPageSize()));
        }
        if (listPoliciesRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean((Boolean)listPoliciesRequest.getAscendingOrder()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

