/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPrincipalThingsRequestMarshaller
implements Marshaller<Request<ListPrincipalThingsRequest>, ListPrincipalThingsRequest> {
    public Request<ListPrincipalThingsRequest> marshall(ListPrincipalThingsRequest listPrincipalThingsRequest) {
        if (listPrincipalThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListPrincipalThingsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPrincipalThingsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalThingsRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString((String)listPrincipalThingsRequest.getPrincipal()));
        }
        String uriResourcePath = "/principals/things";
        if (listPrincipalThingsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listPrincipalThingsRequest.getNextToken()));
        }
        if (listPrincipalThingsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listPrincipalThingsRequest.getMaxResults()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

