/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListThingTypesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListThingTypesRequestMarshaller
implements Marshaller<Request<ListThingTypesRequest>, ListThingTypesRequest> {
    public Request<ListThingTypesRequest> marshall(ListThingTypesRequest listThingTypesRequest) {
        if (listThingTypesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListThingTypesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listThingTypesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/thing-types";
        if (listThingTypesRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listThingTypesRequest.getNextToken()));
        }
        if (listThingTypesRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listThingTypesRequest.getMaxResults()));
        }
        if (listThingTypesRequest.getThingTypeName() != null) {
            request.addParameter("thingTypeName", StringUtils.fromString((String)listThingTypesRequest.getThingTypeName()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

