/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListThingsRequestMarshaller
implements Marshaller<Request<ListThingsRequest>, ListThingsRequest> {
    public Request<ListThingsRequest> marshall(ListThingsRequest listThingsRequest) {
        if (listThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListThingsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listThingsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/things";
        if (listThingsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listThingsRequest.getNextToken()));
        }
        if (listThingsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listThingsRequest.getMaxResults()));
        }
        if (listThingsRequest.getAttributeName() != null) {
            request.addParameter("attributeName", StringUtils.fromString((String)listThingsRequest.getAttributeName()));
        }
        if (listThingsRequest.getAttributeValue() != null) {
            request.addParameter("attributeValue", StringUtils.fromString((String)listThingsRequest.getAttributeValue()));
        }
        if (listThingsRequest.getThingTypeName() != null) {
            request.addParameter("thingTypeName", StringUtils.fromString((String)listThingsRequest.getThingTypeName()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

