/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListTopicRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTopicRulesRequestMarshaller
implements Marshaller<Request<ListTopicRulesRequest>, ListTopicRulesRequest> {
    public Request<ListTopicRulesRequest> marshall(ListTopicRulesRequest listTopicRulesRequest) {
        if (listTopicRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListTopicRulesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTopicRulesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/rules";
        if (listTopicRulesRequest.getTopic() != null) {
            request.addParameter("topic", StringUtils.fromString((String)listTopicRulesRequest.getTopic()));
        }
        if (listTopicRulesRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listTopicRulesRequest.getMaxResults()));
        }
        if (listTopicRulesRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listTopicRulesRequest.getNextToken()));
        }
        if (listTopicRulesRequest.getRuleDisabled() != null) {
            request.addParameter("ruleDisabled", StringUtils.fromBoolean((Boolean)listTopicRulesRequest.getRuleDisabled()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

