/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.PolicyVersion;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class PolicyVersionJsonUnmarshaller
implements Unmarshaller<PolicyVersion, JsonUnmarshallerContext> {
    private static PolicyVersionJsonUnmarshaller instance;

    PolicyVersionJsonUnmarshaller() {
    }

    public PolicyVersion unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        PolicyVersion policyVersion = new PolicyVersion();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("versionId")) {
                policyVersion.setVersionId(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("isDefaultVersion")) {
                policyVersion.setIsDefaultVersion(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("createDate")) {
                policyVersion.setCreateDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return policyVersion;
    }

    public static PolicyVersionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PolicyVersionJsonUnmarshaller();
        }
        return instance;
    }
}

