/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.RegisterCACertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RegisterCACertificateRequestMarshaller
implements Marshaller<Request<RegisterCACertificateRequest>, RegisterCACertificateRequest> {
    public Request<RegisterCACertificateRequest> marshall(RegisterCACertificateRequest registerCACertificateRequest) {
        if (registerCACertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RegisterCACertificateRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerCACertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/cacertificate";
        if (registerCACertificateRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean((Boolean)registerCACertificateRequest.getSetAsActive()));
        }
        if (registerCACertificateRequest.getAllowAutoRegistration() != null) {
            request.addParameter("allowAutoRegistration", StringUtils.fromBoolean((Boolean)registerCACertificateRequest.getAllowAutoRegistration()));
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (registerCACertificateRequest.getCaCertificate() != null) {
                String caCertificate = registerCACertificateRequest.getCaCertificate();
                jsonWriter.name("caCertificate");
                jsonWriter.value(caCertificate);
            }
            if (registerCACertificateRequest.getVerificationCertificate() != null) {
                String verificationCertificate = registerCACertificateRequest.getVerificationCertificate();
                jsonWriter.name("verificationCertificate");
                jsonWriter.value(verificationCertificate);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

