/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.RegisterCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RegisterCertificateRequestMarshaller
implements Marshaller<Request<RegisterCertificateRequest>, RegisterCertificateRequest> {
    public Request<RegisterCertificateRequest> marshall(RegisterCertificateRequest registerCertificateRequest) {
        if (registerCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RegisterCertificateRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/certificate/register";
        if (registerCertificateRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean((Boolean)registerCertificateRequest.getSetAsActive()));
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (registerCertificateRequest.getCertificatePem() != null) {
                String certificatePem = registerCertificateRequest.getCertificatePem();
                jsonWriter.name("certificatePem");
                jsonWriter.value(certificatePem);
            }
            if (registerCertificateRequest.getCaCertificatePem() != null) {
                String caCertificatePem = registerCertificateRequest.getCaCertificatePem();
                jsonWriter.name("caCertificatePem");
                jsonWriter.value(caCertificatePem);
            }
            if (registerCertificateRequest.getStatus() != null) {
                String status = registerCertificateRequest.getStatus();
                jsonWriter.name("status");
                jsonWriter.value(status);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

