/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ReplaceTopicRuleRequest;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.services.iot.model.transform.TopicRulePayloadJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ReplaceTopicRuleRequestMarshaller
implements Marshaller<Request<ReplaceTopicRuleRequest>, ReplaceTopicRuleRequest> {
    public Request<ReplaceTopicRuleRequest> marshall(ReplaceTopicRuleRequest replaceTopicRuleRequest) {
        if (replaceTopicRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ReplaceTopicRuleRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/rules/{ruleName}";
        uriResourcePath = uriResourcePath.replace("{ruleName}", replaceTopicRuleRequest.getRuleName() == null ? "" : StringUtils.fromString((String)replaceTopicRuleRequest.getRuleName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (replaceTopicRuleRequest.getTopicRulePayload() != null) {
                TopicRulePayload topicRulePayload = replaceTopicRuleRequest.getTopicRulePayload();
                TopicRulePayloadJsonMarshaller.getInstance().marshall(topicRulePayload, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

