/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.S3Action;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class S3ActionJsonUnmarshaller
implements Unmarshaller<S3Action, JsonUnmarshallerContext> {
    private static S3ActionJsonUnmarshaller instance;

    S3ActionJsonUnmarshaller() {
    }

    public S3Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        S3Action s3Action = new S3Action();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("roleArn")) {
                s3Action.setRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("bucketName")) {
                s3Action.setBucketName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("key")) {
                s3Action.setKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("cannedAcl")) {
                s3Action.setCannedAcl(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return s3Action;
    }

    public static S3ActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ActionJsonUnmarshaller();
        }
        return instance;
    }
}

