/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.SnsAction;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class SnsActionJsonUnmarshaller
implements Unmarshaller<SnsAction, JsonUnmarshallerContext> {
    private static SnsActionJsonUnmarshaller instance;

    SnsActionJsonUnmarshaller() {
    }

    public SnsAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        SnsAction snsAction = new SnsAction();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("targetArn")) {
                snsAction.setTargetArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("roleArn")) {
                snsAction.setRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("messageFormat")) {
                snsAction.setMessageFormat(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return snsAction;
    }

    public static SnsActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SnsActionJsonUnmarshaller();
        }
        return instance;
    }
}

