/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.ThingAttribute;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Map;

class ThingAttributeJsonMarshaller {
    private static ThingAttributeJsonMarshaller instance;

    ThingAttributeJsonMarshaller() {
    }

    public void marshall(ThingAttribute thingAttribute, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (thingAttribute.getThingName() != null) {
            String thingName = thingAttribute.getThingName();
            jsonWriter.name("thingName");
            jsonWriter.value(thingName);
        }
        if (thingAttribute.getThingTypeName() != null) {
            String thingTypeName = thingAttribute.getThingTypeName();
            jsonWriter.name("thingTypeName");
            jsonWriter.value(thingTypeName);
        }
        if (thingAttribute.getAttributes() != null) {
            Map<String, String> attributes = thingAttribute.getAttributes();
            jsonWriter.name("attributes");
            jsonWriter.beginObject();
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                String attributesValue = attributesEntry.getValue();
                if (attributesValue == null) continue;
                jsonWriter.name(attributesEntry.getKey());
                jsonWriter.value(attributesValue);
            }
            jsonWriter.endObject();
        }
        if (thingAttribute.getVersion() != null) {
            Long version = thingAttribute.getVersion();
            jsonWriter.name("version");
            jsonWriter.value((Number)version);
        }
        jsonWriter.endObject();
    }

    public static ThingAttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ThingAttributeJsonMarshaller();
        }
        return instance;
    }
}

