/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRule;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class TopicRuleJsonMarshaller {
    private static TopicRuleJsonMarshaller instance;

    TopicRuleJsonMarshaller() {
    }

    public void marshall(TopicRule topicRule, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (topicRule.getRuleName() != null) {
            String ruleName = topicRule.getRuleName();
            jsonWriter.name("ruleName");
            jsonWriter.value(ruleName);
        }
        if (topicRule.getSql() != null) {
            String sql = topicRule.getSql();
            jsonWriter.name("sql");
            jsonWriter.value(sql);
        }
        if (topicRule.getDescription() != null) {
            String description = topicRule.getDescription();
            jsonWriter.name("description");
            jsonWriter.value(description);
        }
        if (topicRule.getCreatedAt() != null) {
            Date createdAt = topicRule.getCreatedAt();
            jsonWriter.name("createdAt");
            jsonWriter.value(createdAt);
        }
        if (topicRule.getActions() != null) {
            List<Action> actions = topicRule.getActions();
            jsonWriter.name("actions");
            jsonWriter.beginArray();
            for (Action actionsItem : actions) {
                if (actionsItem == null) continue;
                ActionJsonMarshaller.getInstance().marshall(actionsItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (topicRule.getRuleDisabled() != null) {
            Boolean ruleDisabled = topicRule.getRuleDisabled();
            jsonWriter.name("ruleDisabled");
            jsonWriter.value(ruleDisabled.booleanValue());
        }
        if (topicRule.getAwsIotSqlVersion() != null) {
            String awsIotSqlVersion = topicRule.getAwsIotSqlVersion();
            jsonWriter.name("awsIotSqlVersion");
            jsonWriter.value(awsIotSqlVersion);
        }
        jsonWriter.endObject();
    }

    public static TopicRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRuleJsonMarshaller();
        }
        return instance;
    }
}

