/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.TopicRuleListItem;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class TopicRuleListItemJsonUnmarshaller
implements Unmarshaller<TopicRuleListItem, JsonUnmarshallerContext> {
    private static TopicRuleListItemJsonUnmarshaller instance;

    TopicRuleListItemJsonUnmarshaller() {
    }

    public TopicRuleListItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        TopicRuleListItem topicRuleListItem = new TopicRuleListItem();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("ruleArn")) {
                topicRuleListItem.setRuleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ruleName")) {
                topicRuleListItem.setRuleName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("topicPattern")) {
                topicRuleListItem.setTopicPattern(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("createdAt")) {
                topicRuleListItem.setCreatedAt(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ruleDisabled")) {
                topicRuleListItem.setRuleDisabled(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return topicRuleListItem;
    }

    public static TopicRuleListItemJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRuleListItemJsonUnmarshaller();
        }
        return instance;
    }
}

