/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class TopicRulePayloadJsonMarshaller {
    private static TopicRulePayloadJsonMarshaller instance;

    TopicRulePayloadJsonMarshaller() {
    }

    public void marshall(TopicRulePayload topicRulePayload, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (topicRulePayload.getSql() != null) {
            String sql = topicRulePayload.getSql();
            jsonWriter.name("sql");
            jsonWriter.value(sql);
        }
        if (topicRulePayload.getDescription() != null) {
            String description = topicRulePayload.getDescription();
            jsonWriter.name("description");
            jsonWriter.value(description);
        }
        if (topicRulePayload.getActions() != null) {
            List<Action> actions = topicRulePayload.getActions();
            jsonWriter.name("actions");
            jsonWriter.beginArray();
            for (Action actionsItem : actions) {
                if (actionsItem == null) continue;
                ActionJsonMarshaller.getInstance().marshall(actionsItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (topicRulePayload.getRuleDisabled() != null) {
            Boolean ruleDisabled = topicRulePayload.getRuleDisabled();
            jsonWriter.name("ruleDisabled");
            jsonWriter.value(ruleDisabled.booleanValue());
        }
        if (topicRulePayload.getAwsIotSqlVersion() != null) {
            String awsIotSqlVersion = topicRulePayload.getAwsIotSqlVersion();
            jsonWriter.name("awsIotSqlVersion");
            jsonWriter.value(awsIotSqlVersion);
        }
        jsonWriter.endObject();
    }

    public static TopicRulePayloadJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TopicRulePayloadJsonMarshaller();
        }
        return instance;
    }
}

