/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.TransferCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class TransferCertificateRequestMarshaller
implements Marshaller<Request<TransferCertificateRequest>, TransferCertificateRequest> {
    public Request<TransferCertificateRequest> marshall(TransferCertificateRequest transferCertificateRequest) {
        if (transferCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(TransferCertificateRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)transferCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/transfer-certificate/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", transferCertificateRequest.getCertificateId() == null ? "" : StringUtils.fromString((String)transferCertificateRequest.getCertificateId()));
        if (transferCertificateRequest.getTargetAwsAccount() != null) {
            request.addParameter("targetAwsAccount", StringUtils.fromString((String)transferCertificateRequest.getTargetAwsAccount()));
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (transferCertificateRequest.getTransferMessage() != null) {
                String transferMessage = transferCertificateRequest.getTransferMessage();
                jsonWriter.name("transferMessage");
                jsonWriter.value(transferMessage);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

