/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.AttributePayload;
import com.amazonaws.services.iot.model.UpdateThingRequest;
import com.amazonaws.services.iot.model.transform.AttributePayloadJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateThingRequestMarshaller
implements Marshaller<Request<UpdateThingRequest>, UpdateThingRequest> {
    public Request<UpdateThingRequest> marshall(UpdateThingRequest updateThingRequest) {
        if (updateThingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateThingRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = uriResourcePath.replace("{thingName}", updateThingRequest.getThingName() == null ? "" : StringUtils.fromString((String)updateThingRequest.getThingName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateThingRequest.getThingTypeName() != null) {
                String thingTypeName = updateThingRequest.getThingTypeName();
                jsonWriter.name("thingTypeName");
                jsonWriter.value(thingTypeName);
            }
            if (updateThingRequest.getAttributePayload() != null) {
                AttributePayload attributePayload = updateThingRequest.getAttributePayload();
                jsonWriter.name("attributePayload");
                AttributePayloadJsonMarshaller.getInstance().marshall(attributePayload, jsonWriter);
            }
            if (updateThingRequest.getExpectedVersion() != null) {
                Long expectedVersion = updateThingRequest.getExpectedVersion();
                jsonWriter.name("expectedVersion");
                jsonWriter.value((Number)expectedVersion);
            }
            if (updateThingRequest.getRemoveThingType() != null) {
                Boolean removeThingType = updateThingRequest.getRemoveThingType();
                jsonWriter.name("removeThingType");
                jsonWriter.value(removeThingType.booleanValue());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

