/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        if (publishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PublishRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/topics/{topic}";
        uriResourcePath = uriResourcePath.replace("{topic}", publishRequest.getTopic() == null ? "" : StringUtils.fromString((String)publishRequest.getTopic()));
        if (publishRequest.getQos() != null) {
            request.addParameter("qos", StringUtils.fromInteger((Integer)publishRequest.getQos()));
        }
        request.setResourcePath(uriResourcePath);
        request.addHeader("Content-Length", Integer.toString(publishRequest.getPayload().remaining()));
        request.setContent(BinaryUtils.toStream((ByteBuffer)publishRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

