/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisfirehose.model.PutRecordBatchRequest;
import com.amazonaws.services.kinesisfirehose.model.Record;
import com.amazonaws.services.kinesisfirehose.model.transform.RecordJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class PutRecordBatchRequestMarshaller
implements Marshaller<Request<PutRecordBatchRequest>, PutRecordBatchRequest> {
    public Request<PutRecordBatchRequest> marshall(PutRecordBatchRequest putRecordBatchRequest) {
        if (putRecordBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutRecordBatchRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRecordBatchRequest, "AmazonKinesisFirehose");
        String target = "Firehose_20150804.PutRecordBatch";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, 8192);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gos, StringUtils.UTF8);
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            if (putRecordBatchRequest.getDeliveryStreamName() != null) {
                String deliveryStreamName = putRecordBatchRequest.getDeliveryStreamName();
                jsonWriter.name("DeliveryStreamName");
                jsonWriter.value(deliveryStreamName);
            }
            if (putRecordBatchRequest.getRecords() != null) {
                List<Record> records = putRecordBatchRequest.getRecords();
                jsonWriter.name("Records");
                jsonWriter.beginArray();
                for (Record recordsItem : records) {
                    if (recordsItem == null) continue;
                    RecordJsonMarshaller.getInstance().marshall(recordsItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            gos.finish();
            ((Writer)writer).close();
            byte[] content = baos.toByteArray();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Encoding", "gzip");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

