/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.RecordSender;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

class KinesisStreamRecordSender
implements RecordSender {
    private AmazonKinesis client;
    private String userAgent;

    public KinesisStreamRecordSender(AmazonKinesis client, String userAgent) {
        this.client = client;
        this.userAgent = userAgent;
    }

    @Override
    public List<byte[]> sendBatch(String streamName, List<byte[]> data) throws AmazonClientException {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        PutRecordsRequest request = new PutRecordsRequest();
        request.setStreamName(streamName);
        ArrayList<PutRecordsRequestEntry> records = new ArrayList<PutRecordsRequestEntry>(data.size());
        String partitionKey = UUID.randomUUID().toString();
        for (byte[] d : data) {
            PutRecordsRequestEntry r = new PutRecordsRequestEntry();
            r.setData(ByteBuffer.wrap(d));
            r.setPartitionKey(partitionKey);
            records.add(r);
        }
        request.setRecords(records);
        request.getRequestClientOptions().appendUserAgent(this.userAgent);
        PutRecordsResult result = this.client.putRecords(request);
        int size = result.getRecords().size();
        ArrayList<byte[]> failures = new ArrayList<byte[]>(result.getFailedRecordCount());
        for (int i = 0; i < size; ++i) {
            if (result.getRecords().get(i).getErrorCode() == null) continue;
            failures.add(data.get(i));
        }
        return failures;
    }

    @Override
    public boolean isRecoverable(AmazonClientException ace) {
        if (ace instanceof AmazonServiceException) {
            String errorCode = ((AmazonServiceException)ace).getErrorCode();
            return "InternalFailure".equals(errorCode) || "ServiceUnavailable".equals(errorCode) || "Throttling".equals(errorCode) || "ProvisionedThroughputExceededException".equals(errorCode);
        }
        return ace.getCause() != null && ace.getCause() instanceof IOException;
    }
}

