/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.AbstractKinesisRecorder;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.FileRecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.JSONRecordAdapter;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisStreamRecordSender;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.RecordSender;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class KinesisRecorder
extends AbstractKinesisRecorder {
    private static final String RECORD_FILE_NAME = "kinesis_stream_records";
    private static final String USER_AGENT = KinesisRecorder.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final int MAX_RECORD_SIZE_BYTES = 0x100000;
    private static final Pattern STREAM_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]{1,128}");
    private KinesisStreamRecordSender sender;

    public KinesisRecorder(File directory, Regions region, AWSCredentialsProvider credentialsProvider) {
        this(directory, region, credentialsProvider, new KinesisRecorderConfig());
    }

    public KinesisRecorder(File directory, Regions region, AWSCredentialsProvider credentialsProvider, KinesisRecorderConfig config) {
        super(new FileRecordStore(directory, RECORD_FILE_NAME, config.getMaxStorageSize()), config);
        if (directory == null || credentialsProvider == null || region == null || config == null) {
            throw new IllegalArgumentException("You must pass a non-null credentialsProvider, region, directory, and config to KinesisRecordStore");
        }
        AmazonKinesisClient client = new AmazonKinesisClient(credentialsProvider, config.getClientConfiguration());
        client.setRegion(Region.getRegion((Regions)region));
        this.sender = new KinesisStreamRecordSender(client, USER_AGENT);
        this.checkUpgrade(directory);
    }

    KinesisRecorder(KinesisStreamRecordSender sender, FileRecordStore recordStore, KinesisRecorderConfig config) {
        super(recordStore, config);
        this.sender = sender;
    }

    private void checkUpgrade(final File directory) {
        File recordsDir = new File(directory, "KinesisRecorder");
        File oldRecordsFile = new File(recordsDir, "KinesisRecords");
        if (oldRecordsFile.isFile()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    KinesisRecorder.this.upgrade(directory);
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgrade(File directory) {
        KinesisRecorder kinesisRecorder = this;
        synchronized (kinesisRecorder) {
            File recordsDir = new File(directory, "KinesisRecorder");
            File oldRecordsFile = new File(recordsDir, "KinesisRecords");
            if (!oldRecordsFile.isFile()) {
                return;
            }
            FileRecordStore frs = new FileRecordStore(directory, "KinesisRecords", Long.MAX_VALUE);
            FileRecordStore.RecordIterator iterator = frs.iterator();
            while (iterator.hasNext()) {
                try {
                    JSONObject json = new JSONObject(iterator.next());
                    this.saveRecord(JSONRecordAdapter.getData(json).array(), JSONRecordAdapter.getStreamName(json));
                }
                catch (JSONException e) {}
            }
            try {
                iterator.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            oldRecordsFile.delete();
        }
    }

    @Override
    protected RecordSender getRecordSender() {
        return this.sender;
    }

    @Override
    public void saveRecord(byte[] data, String streamName) {
        if (streamName == null || !STREAM_NAME_PATTERN.matcher(streamName).matches()) {
            throw new IllegalArgumentException("Invalid stream name: " + streamName);
        }
        if (data == null || data.length == 0 || data.length > 0x100000) {
            throw new IllegalArgumentException("Invalid data size.");
        }
        super.saveRecord(data, streamName);
    }
}

