/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.HashKeyRange;
import com.amazonaws.services.kinesis.model.SequenceNumberRange;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.transform.HashKeyRangeJsonMarshaller;
import com.amazonaws.services.kinesis.model.transform.SequenceNumberRangeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class ShardJsonMarshaller {
    private static ShardJsonMarshaller instance;

    ShardJsonMarshaller() {
    }

    public void marshall(Shard shard, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (shard.getShardId() != null) {
            String shardId = shard.getShardId();
            jsonWriter.name("ShardId");
            jsonWriter.value(shardId);
        }
        if (shard.getParentShardId() != null) {
            String parentShardId = shard.getParentShardId();
            jsonWriter.name("ParentShardId");
            jsonWriter.value(parentShardId);
        }
        if (shard.getAdjacentParentShardId() != null) {
            String adjacentParentShardId = shard.getAdjacentParentShardId();
            jsonWriter.name("AdjacentParentShardId");
            jsonWriter.value(adjacentParentShardId);
        }
        if (shard.getHashKeyRange() != null) {
            HashKeyRange hashKeyRange = shard.getHashKeyRange();
            jsonWriter.name("HashKeyRange");
            HashKeyRangeJsonMarshaller.getInstance().marshall(hashKeyRange, jsonWriter);
        }
        if (shard.getSequenceNumberRange() != null) {
            SequenceNumberRange sequenceNumberRange = shard.getSequenceNumberRange();
            jsonWriter.name("SequenceNumberRange");
            SequenceNumberRangeJsonMarshaller.getInstance().marshall(sequenceNumberRange, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static ShardJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShardJsonMarshaller();
        }
        return instance;
    }
}

