/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class FileManager {
    private final File directory;

    public FileManager(File rootDirectory) {
        this.directory = rootDirectory;
    }

    public File createDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    public File getDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        return dir;
    }

    public Set<File> listFilesInDirectory(String directoryPath) {
        File dir = new File(this.directory, directoryPath);
        return this.listFilesInDirectory(dir);
    }

    public Set<File> listFilesInDirectory(File direc) {
        HashSet<File> filesSet = new HashSet<File>();
        if (direc.exists()) {
            File[] files;
            for (File file : files = direc.listFiles()) {
                filesSet.add(file);
            }
        }
        return Collections.unmodifiableSet(filesSet);
    }

    public File createFile(String filepath) throws IOException {
        File file = new File(this.directory, filepath);
        return this.createFile(file);
    }

    public File createFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            return null;
        }
        return file;
    }

    public boolean deleteFile(String filepath) {
        File file = new File(this.directory, filepath);
        return this.deleteFile(file);
    }

    public boolean deleteFile(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public InputStream newInputStream(String filepath) throws FileNotFoundException {
        File file = new File(this.directory, filepath);
        return this.newInputStream(file);
    }

    public InputStream newInputStream(File file) throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(file);
        return stream;
    }

    public OutputStream newOutputStream(String filepath, boolean append) throws FileNotFoundException {
        File file = new File(this.directory, filepath);
        return this.newOutputStream(file, append);
    }

    public OutputStream newOutputStream(File file, boolean append) throws FileNotFoundException {
        FileOutputStream stream = new FileOutputStream(file, append);
        return stream;
    }
}

