/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.services.kinesis.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTagsForStreamResult
implements Serializable {
    private List<Tag> tags = new ArrayList<Tag>();
    private Boolean hasMoreTags;

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ListTagsForStreamResult withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.tags = new ArrayList<Tag>(tags.length);
        }
        for (Tag value : tags) {
            this.tags.add(value);
        }
        return this;
    }

    public ListTagsForStreamResult withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Boolean isHasMoreTags() {
        return this.hasMoreTags;
    }

    public Boolean getHasMoreTags() {
        return this.hasMoreTags;
    }

    public void setHasMoreTags(Boolean hasMoreTags) {
        this.hasMoreTags = hasMoreTags;
    }

    public ListTagsForStreamResult withHasMoreTags(Boolean hasMoreTags) {
        this.hasMoreTags = hasMoreTags;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getHasMoreTags() != null) {
            sb.append("HasMoreTags: " + this.getHasMoreTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getHasMoreTags() == null ? 0 : this.getHasMoreTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResult)) {
            return false;
        }
        ListTagsForStreamResult other = (ListTagsForStreamResult)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getHasMoreTags() == null ^ this.getHasMoreTags() == null) {
            return false;
        }
        return other.getHasMoreTags() == null || other.getHasMoreTags().equals(this.getHasMoreTags());
    }
}

