/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import java.net.URI;
import java.net.URISyntaxException;

public class PredictEndpointHandler
extends RequestHandler2 {
    public void beforeRequest(Request<?> request) {
        if (request.getOriginalRequest() instanceof PredictRequest) {
            PredictRequest pr = (PredictRequest)request.getOriginalRequest();
            if (pr.getPredictEndpoint() == null) {
                throw new AmazonClientException("PredictRequest.PredictEndpoint is required!");
            }
            try {
                request.setEndpoint(new URI(pr.getPredictEndpoint()));
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse PredictRequest.EndpointUrl", (Throwable)e);
            }
        }
    }

    public void afterResponse(Request<?> request, Response<?> response) {
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
    }
}

